<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

class WPBakeryShortCode_ts_client extends WPBakeryShortCode {

	protected function content( $atts, $content = null ) {

		extract( shortcode_atts( array(
			'title'		            => '',
			'link'		            => '',
			'logo'			        => '',
			'animate_block'			=> 'false',
			'animation_delay'		=> '',
		), $atts ) );
		$logo_url = '';
		if ( $logo != '') {
			$logo_url = wp_get_attachment_url( $logo );
		}
		ob_start();

		$wrapper_class = array();
		if( $animate_block == 'yes' ) {
			$wrapper_class[] = 'wow';
		}
		$wrapper_class = implode( ' ', $wrapper_class );
		?>
		<div class="clients reveal-effect masker wow">
			
			
			
			<?php if( $logo_url != '' ) { ?>
                <figure>
                    <img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php echo esc_attr( $title ); ?>">
                    <figcaption><a href="<?php echo esc_url( $link ); ?>" title="<?php echo esc_html( $title ); ?>"><?php echo esc_html( $title ); ?></a></figcaption>
                </figure>
			<?php } ?>
		</div>
		<?php

		return ob_get_clean();
	}
}


vc_map( array(
	"base" 			    => "ts_client",
	"name" 			    => __( 'Client', 'themezinho' ),
	"icon"              => THEMEZINHO_CORE_URI . "assets/img/custom.png",
	"content_element"   => true,
	"category" 		    => PAGE_BUILDER_GROUP,
	'params' => array(
		array(
			"type" 			=> 	"textfield",
			"heading" 		=> 	__( 'Title', 'themezinho' ),
			"param_name" 	=> 	"title",
			"group" 		=> 'General',
		),
		array(
			"type" 			=> 	"textfield",
			"heading" 		=> 	__( 'Link', 'themezinho' ),
			"param_name" 	=> 	"link",
			"group" 		=> 'General',
		),
		array(
			"type" 			=> 	"attach_image",
			"heading" 		=> 	__( 'Logo', 'themezinho' ),
			"param_name" 	=> 	"logo",
			"group" 		=> 'General',
		),
	),
) );
