<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

class WPBakeryShortCode_ts_hero_slider extends WPBakeryShortCode {

	protected function content( $atts, $content = null ) {

		extract( shortcode_atts( array(
			'hero_slider'		=> 0,
		), $atts ) );

//		 if( !is_int( $hero_slider ) ) {
//		 	return;
//		 }
		ob_start();
		$args = array (
			'post_type'		=> 'hero',
			'post__in'		=> array( $hero_slider )
	    );

		$the_query = new WP_Query( $args );
		if ( $the_query->have_posts() ) :
			while ( $the_query->have_posts() ) :
				$the_query->the_post();

				$hero_type = get_field( 'type' );
				$disable_scrolldown = ( get_field( 'disable_scroll_down' ) ) ? true : false;

				if( $hero_type === 'swiper' ) :

					if( have_rows('slider') ):

						$transition_speed = ( get_field( 'transition_speed' ) ) ? get_field( 'transition_speed' ) : 600;
						$auto_play_delay = ( get_field( 'auto_play_delay' ) ) ? get_field( 'auto_play_delay' ) : 3500;
						$loop = ( get_field( 'disable_loop' ) ) ? 'disable' : 'enable';

                        $progress = ( get_field( 'disable_progress' ) ) ? false : true;
                        $page_number = ( get_field( 'disable_page_number' ) ) ? false : true;
                        $pagination = ( get_field( 'disable_pagination' ) ) ? false : true;
                        $navigation = ( get_field( 'disable_navigation' ) ) ? false : true;


						$slides = count( get_field( 'slider' ) );

						if( $slides < 2 ) {
						    $loop = 'disable';
                        }
						?>
                        <header class="slider">
							
							
                            <div class="swiper-container gallery-top"
                                 data-speed="<?php echo esc_attr( $transition_speed ); ?>"
                                 data-autoplay-delay="<?php echo esc_attr( $auto_play_delay ); ?>"
                                 data-loop="<?php echo esc_attr( $loop ); ?>"
                                >
                                <div class="swiper-wrapper">
                                    <?php
                                    while ( have_rows('slider') ) : the_row();
                                        $background_image = get_sub_field( 'background_image' );
                                        $slide_background_video = get_sub_field( 'slide_background_video' );
                                        ?>

                                        <div class="swiper-slide bg-image" data-background="<?php echo esc_url( $background_image ); ?>">
											
											<?php if ($slide_background_video != '') { ?>
											<div class="slide-video-bg">
											 <video src="<?php echo esc_url( $slide_background_video ); ?>" muted loop autoplay></video>
												</div>
											<!-- end slide-video-bg -->
											 	<?php } ?>
											
                                        </div>
									<!-- end swiper-slide -->
                                        <?php
                                    endwhile;
                                    ?>
                                </div>
								<!-- end swiper-wrapper -->
                                

								
								
								   <div class="swiper-container gallery-thumbs">
      <div class="swiper-wrapper">
		  <?php
                                    while ( have_rows('slider') ) : the_row();
                                        ?>
		  
        <div class="swiper-slide"><h1><?php the_sub_field( 'title' ); ?></h1> 
			
			
			
			
                                                    <?php if( $button_link = get_sub_field( 'button_link' ) ){
                                                        $button_label = get_sub_field( 'button_label' );
                                                        ?>
												
											 <a href="<?php echo esc_url( $button_link ); ?>" title="<?php echo esc_attr( $button_label ); ?>">
           <?php echo esc_html( $button_label ); ?> </a> 
          
												
                                                    <?php } ?>
			
			
			
		  
		  </div>
		     <?php
                                    endwhile;
                                    ?>
		  
      </div>
      <!-- end swiper-wrapper --> 
    </div>
    <!-- end gallery-thumbs --> 
							
							
								 
									
									
                                 
							
                           
									
									
									
									
                                </div>
							<!-- end swiper-container -->
							
							
							
							        	

                           
                              
                              
									
									<?php if( $progress ) { ?>
									<div class="slide-progress"><span>01</span>
										
										<?php if( $page_number ) { ?>
                                    <div class="swiper-pagination"></div>
                                <?php } ?>
										
										<span class="total-slides">
											</span></div>
									<?php } ?>
									
									

                                <?php if( $navigation ) {
                                    $prev_label = get_field( 'navigation_previous_label' ) ? get_field( 'navigation_previous_label' ) : __('PREV', 'tourog');
                                    $next_label = get_field( 'navigation_next_label' ) ? get_field( 'navigation_next_label' ) : __('PREV', 'tourog');
                                    ?>
									
									<div class="slider-controls">
      <div class="swiper-button-prev" data-text="<?php echo esc_html( $prev_label ); ?>"><?php echo esc_html( $prev_label ); ?></div>
      <!-- end swiper-button-prev -->
      <div class="swiper-button-next" data-text="<?php echo esc_html( $next_label ); ?>"><?php echo esc_html( $next_label ); ?></div>
      <!-- end swiper-button-next --> 
    </div>
                                <?php } ?>
									
									
									
									
									
									
									
                             
                           
                        </header>
<?php 
		endif;


elseif( $hero_type === 'carousel' ) :

					if( have_rows('carousel') ):

						$transition_speed = ( get_field( 'transition_speed' ) ) ? get_field( 'transition_speed' ) : 600;
						$auto_play_delay = ( get_field( 'auto_play_delay' ) ) ? get_field( 'auto_play_delay' ) : 3500;
						$loop = ( get_field( 'disable_loop' ) ) ? 'disable' : 'enable';

                        $progress = ( get_field( 'disable_progress' ) ) ? false : true;
                        $page_number = ( get_field( 'disable_page_number' ) ) ? false : true;
                        $pagination = ( get_field( 'disable_pagination' ) ) ? false : true;
                        $navigation = ( get_field( 'disable_navigation' ) ) ? false : true;


						$slides = count( get_field( 'carousel' ) );

						if( $slides < 2 ) {
						    $loop = 'disable';
                        }
						?>
                        <header class="slider">
							
							
                            <div class="carousel-slider"
                                 data-speed="<?php echo esc_attr( $transition_speed ); ?>"
                                 data-autoplay-delay="<?php echo esc_attr( $auto_play_delay ); ?>"
                                 data-loop="<?php echo esc_attr( $loop ); ?>"
                                >
                                <div class="swiper-wrapper">
                                    <?php
                                    while ( have_rows('slider') ) : the_row();
                                        $background_image = get_sub_field( 'background_image' );
                                        $slide_background_video = get_sub_field( 'slide_background_video' );
                                        ?>

                                        <div class="swiper-slide bg-image" data-background="<?php echo esc_url( $background_image ); ?>">
											
											<?php if ($slide_background_video != '') { ?>
											<div class="slide-video-bg">
											 <video src="<?php echo esc_url( $slide_background_video ); ?>" muted loop autoplay></video>
												</div>
											<!-- end slide-video-bg -->
											 	<?php } ?>
											
											
												
			<h1><?php the_sub_field( 'title' ); ?></h1> 
			
			
			
			
                                                    <?php if( $button_link = get_sub_field( 'button_link' ) ){
                                                        $button_label = get_sub_field( 'button_label' );
                                                        ?>
												
											 <a href="<?php echo esc_url( $button_link ); ?>" title="<?php echo esc_attr( $button_label ); ?>">
           <?php echo esc_html( $button_label ); ?> </a> 
          
												
                                                    <?php } ?>
											
                                        </div>
									<!-- end swiper-slide -->
                                        <?php
                                    endwhile;
                                    ?>
                                </div>
								<!-- end swiper-wrapper -->
                                

								
								
							
									
                                </div>
							<!-- end swiper-container -->
							
							
							
							        	

                           
                              
                              
									
									<?php if( $progress ) { ?>
									<div class="slide-progress"><span>01</span>
										
										<?php if( $page_number ) { ?>
                                    <div class="swiper-pagination"></div>
                                <?php } ?>
										
										<span class="total-slides">
											</span></div>
									<?php } ?>
									
									

                                <?php if( $navigation ) {
                                    $prev_label = get_field( 'navigation_previous_label' ) ? get_field( 'navigation_previous_label' ) : __('PREV', 'tourog');
                                    $next_label = get_field( 'navigation_next_label' ) ? get_field( 'navigation_next_label' ) : __('PREV', 'tourog');
                                    ?>
									
									<div class="slider-controls">
      <div class="swiper-button-prev" data-text="<?php echo esc_html( $prev_label ); ?>"><?php echo esc_html( $prev_label ); ?></div>
      <!-- end swiper-button-prev -->
      <div class="swiper-button-next" data-text="<?php echo esc_html( $next_label ); ?>"><?php echo esc_html( $next_label ); ?></div>
      <!-- end swiper-button-next --> 
    </div>
                                <?php } ?>
									
									
									
									
									
									
									
                             
                           
                        </header>

						<?php
					endif;

                    elseif( $hero_type === 'video' ) :
                        ?>
                        <header class="video-hero">
                          
                           

							
							

                            <div class="video-bg">
                                <video src="<?php echo esc_url( get_field( 'background_video' ) ); ?>" muted loop autoplay playsinline></video>
                            </div>
							<!-- end video-bg -->
							 <div class="inner">
                                    

                                    <h1> <?php the_field( 'video_bg_title' ); ?> </h1>

                                    <?php if( get_field( 'video_bg_button_link' ) ){ ?>
									<a href="<?php echo esc_url( get_field( 'video_bg_button_link' ) ); ?>" title="<?php echo esc_attr( get_field( 'video_bg_button_label' ) ); ?>">
								 <?php echo esc_attr( get_field( 'video_bg_button_label' ) ); ?>
								 </a>
		 
									
									
                                    <?php } ?>
                                </div>

							
							
                        </header>
                        <?php

                endif;

			endwhile;
		endif;

		return ob_get_clean();
	}
}

vc_map( array(
	"base" 			    => "ts_hero_slider",
	"name" 			    => __( 'Hero Slider', 'ts' ),
	"icon"              => THEMEZINHO_CORE_URI . "assets/img/custom.png",
	"content_element"   => true,
	"category" 		    => PAGE_BUILDER_GROUP,
	'params' => array(
		array(
			"type" 			=> 	"dropdown",
			"heading" 		=> 	__( 'Hero Slider', 'ts' ),
			"param_name" 	=> 	"hero_slider",
			"group" 		=> "General",
			"description"	=> __( 'Select the slider that you created in Hero Slider section. Check documentation for further detail.', 'ts' ),
			"value"			=>	ts_get_hero_slider()
		)
	),
) );
