<?php
if ( !defined( 'ABSPATH' ) ) {
  die( '-1' );
}

class WPBakeryShortCode_ts_milestones extends WPBakeryShortCode {

  protected function content( $atts, $content = null ) {

    extract( shortcode_atts( array(
      'value' => '',
      'tagline' => '',
      'title' => '',
    ), $atts ) );

    ob_start();


    ?>
<div class="milestones wow <?php echo esc_attr( $wrapper_class ); ?>" data-splitting>
  <?php if( $value != '' ) { ?>
  <span class="odometer" data-count="<?php echo esc_attr( $value ); ?>" data-status="yes">0</span>
  <?php } ?>
  <?php if( $tagline != '' ) { ?>
  <h6><?php echo esc_html( $tagline ); ?></h6>
  <?php } ?>
  <?php if( $title != '' ) { ?>
  <h4><?php echo esc_html( $title ); ?></h4>
  <?php } ?>
</div>
<?php

return ob_get_clean();
}
}


vc_map( array(
  "base" => "ts_milestones",
  "name" => __( 'Milestones', 'themezinho' ),
  "icon" => THEMEZINHO_CORE_URI . "assets/img/custom.png",
  "content_element" => true,
  "category" => PAGE_BUILDER_GROUP,
  'params' => array(
    array(
      "type" => "textfield",
      "heading" => __( 'Value', 'themezinho' ),
      "param_name" => "value",
      "group" => 'General',
    ),
    array(
      "type" => "textfield",
      "heading" => __( 'Title', 'themezinho' ),
      "param_name" => "title",
      "group" => 'General',
    ),
    array(
      "type" => "textfield",
      "heading" => __( 'Tagline', 'themezinho' ),
      "param_name" => "tagline",
      "group" => 'General',
    )
  ),
) );
