<?php
if ( !defined( 'ABSPATH' ) ) {
  die( '-1' );
}

class WPBakeryShortCode_ts_section_title extends WPBakeryShortCode {

  protected function content( $atts, $content = null ) {

    extract( shortcode_atts( array(
	  'title_color' => 'false',
	  'title_align' => '',
      'tagline' => '',
      'title' => '',
      'link_label' => '',
      'link_url' => '',
      'animate_block' => 'false',
      'animation_type' => 'fadeIn',
      'animation_delay' => '',
    ), $atts ) );

    ob_start();

    $wrapper_class = array();

    if ( $animate_block == 'yes' ) {
      $wrapper_class[] = 'wow';
      $wrapper_class[] = $animation_type;
    }

    $wrapper_class = implode( ' ', $wrapper_class );
	  
	  
	  
	  
	  
	  
	  $color_class = array();

    if ( $title_color == 'yes' ) {
      $color_class[] = 'light';
    }

    $color_class = implode( ' ', $color_class );
	  
	  
    ?>
<div class="section-title wow <?php echo esc_attr( $title_align ); ?>
			<?php echo esc_attr( $color_class ); ?> <?php if( $title_color == 'yes') ?>
			<?php echo esc_attr( $wrapper_class ); ?>" data-splitting>
	
	
	
	
	
	
  <?php if( $title ) { ?>
  <h2><?php echo wp_kses_post( $title ); ?></h2>
  <?php } ?>
	
	<?php if( $tagline ) { ?>
  <h5>
  <?php echo wp_kses_post( $tagline ); ?>
  </h5>
  <?php } ?>

<?php if( $link_label != '' ) { ?>
  <a href="<?php echo esc_attr( $link_url ); ?>" title="<?php echo esc_html( $link_label ); ?>"><?php echo esc_html( $link_label ); ?></a>
  <?php } ?>



</div>
<?php

return ob_get_clean();
}
}


vc_map( array(
  "base" => "ts_section_title",
  "name" => __( 'Section Title Block', 'themezinho' ),
  "icon" => THEMEZINHO_CORE_URI . "assets/img/custom.png",
  "content_element" => true,
  "category" => PAGE_BUILDER_GROUP,
  'params' => array(
	  array(
      "type" => "dropdown",
      "heading" => __( 'Title Light Color ?', 'themezinho' ),
      "param_name" => "title_color",
      "group" => 'General',
      "value" => array(
        "No" => 'no',
        "Yes" => 'yes',
      )
    ),
    array(
      "type" => "textfield",
      "heading" => __( 'Title Align', 'themezinho' ),
      "param_name" => "title_align",
      "group" => 'General',
      "description" => 'You can use text-right or text-center if default valu it is text-left',
    ),
    array(
      "type" => "textfield",
      "heading" => __( 'Title', 'themezinho' ),
      "param_name" => "title",
      "group" => 'General',
    ),
	 array(
      "type" => "textfield",
      "heading" => __( 'Subtitle', 'themezinho' ),
      "param_name" => "tagline",
      "group" => 'General',
    ),
	 array(
      "type" => "textfield",
      "heading" => __( 'Link Label', 'themezinho' ),
      "param_name" => "link_label",
      "group" => 'General',
    ),
	 array(
      "type" => "textfield",
      "heading" => __( 'Link URL', 'themezinho' ),
      "param_name" => "link_url",
      "group" => 'General',
    ),
    
  ),
) );
