<?php
if ( !defined( 'ABSPATH' ) ) {
  die( '-1' );
}

class WPBakeryShortCode_ts_team_members extends WPBakeryShortCode {

  protected function content( $atts, $content = null ) {

    extract( shortcode_atts( array(
      'member' => '',
      'member_name' => '',
      'social_icon' => '',
      'social_url' => '',
      'details' => '',
      'value' => '',
      'title' => '',
      'animate_block' => 'false',
    ), $atts ) );
    $member_url = '';
    if ( $member != '' ) {
      $member_url = wp_get_attachment_url( $member );
    }
    ob_start();

    $wrapper_class = array();
    if ( $animate_block == 'yes' ) {
      $wrapper_class[] = 'wow';
      $wrapper_class[] = 'fadeIn';
    }
    $wrapper_class = implode( ' ', $wrapper_class );
	  $details = vc_param_group_parse_atts( $atts[ 'details' ] );
    ?>
<figure class="team">
 <ul>
    <?php
    $new_accordion_value = array();
    foreach ( $details as $data ) {
      $new_line = $data;

      $new_line[ 'social_icon' ] = isset( $new_line[ 'social_icon' ] ) ? $new_line[ 'social_icon' ] : '';
      $new_line[ 'social_url' ] = isset( $new_line[ 'social_url' ] ) ? $new_line[ 'social_url' ] : '';


      $new_accordion_value[] = $new_line;

    }


    foreach ( $new_accordion_value as $accordion ):


      ?>
    <li><a href="<?php echo esc_url($accordion['social_url']); ?>"> <?php echo wp_kses_post($accordion['social_icon']); ?></a> </li>
    <?php
    endforeach;
    wp_reset_query();
    ?>
  </ul>
	
	
  <?php if ($member_url != '') { ?>
  <div class="reveal-effect masker wow"> <img src="<?php echo esc_url($member_url); ?>" alt="<?php echo esc_attr($title); ?>"> </div>
  <?php } ?>
  <figcaption class="wow" data-splitting>
    <?php if( $member_name != '' ) { ?>
    <h6><?php echo esc_attr( $member_name ); ?></h6>
    <?php } ?>
    <?php if( $title != '' ) { ?>
    <small><?php echo esc_html( $title ); ?></small>
    <?php } ?>
  </figcaption>
</figure>
<?php

return ob_get_clean();
}
}


vc_map( array(
  "base" => "ts_team_members",
  "name" => __( 'Team Member', 'themezinho' ),
  "icon" => THEMEZINHO_CORE_URI . "assets/img/custom.png",
  "content_element" => true,
  "category" => PAGE_BUILDER_GROUP,
  'params' => array(
    array(
      "type" => "textfield",
      "heading" => __( 'Member Name', 'themezinho' ),
      "param_name" => "member_name",
      "group" => 'General',
    ),
    array(
      "type" => "textfield",
      "heading" => __( 'Job Title', 'themezinho' ),
      "param_name" => "title",
      "group" => 'General',
    ),
    array(
      "type" => "attach_image",
      "heading" => __( 'Member', 'themezinho' ),
      "param_name" => "member",
      "group" => 'General',
    ),
     array(
      "group" => 'General',
      'type' => 'param_group',
      'param_name' => 'details',
      'heading' => __( 'Social Item', 'themezinho' ),
      'params' => array(

        array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __( "Social Icon", 'themezinho' ),
          "param_name" => "social_icon",
          "value" => array(
			  "Facebook" => '<i class="fab fa-facebook-f"></i>',
            "Behance" => '<i class="fab fa-behance"></i>',
            "Github" => '<i class="fab fa-github"></i>',
            "Youtube" => '<i class="fab fa-youtube"></i>',
            "Linkedin" => '<i class="fab fa-linkedin-in"></i>',
            "Instagram" => '<i class="fab fa-instagram"></i>',
            "Twitter" => '<i class="fab fa-twitter"></i>',
            "Dribbble" => '<i class="fab fa-dribbble"></i>'
          )
        ),
        array(
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => __( "Social URL", 'themezinho' ),
          "param_name" => "social_url",
          "value" => ""
        ),

      ),

    ),


    array(
      "type" => "dropdown",
      "heading" => __( 'Animate', 'themezinho' ),
      "param_name" => "animate_block",
      "group" => 'Animation',
      "value" => array(
        "No" => 'no',
        "Yes" => 'yes',
      )
    ),
    array(
      "type" => "dropdown",
      "heading" => __( 'Animation Type', 'themezinho' ),
      "param_name" => "animation_type",
      "dependency" => array( 'element' => "animate_block", 'value' => 'yes' ),
      "group" => 'Animation',
      "value" => motts_animations()
    ),
    array(
      "type" => "textfield",
      "heading" => __( 'Animation Delay', 'themezinho' ),
      "param_name" => "animation_delay",
      "dependency" => array( 'element' => "animate_block", 'value' => 'yes' ),
      "description" => __( 'Animation delay set in second e.g. 0.6s', 'themezinho' ),
      "group" => 'Animation',
    )
  ),
) );
