<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

class WPBakeryShortCode_ts_text_content_block extends WPBakeryShortCode {

	protected function content( $atts, $content = null ) {

		extract( shortcode_atts( array(
			'block_type'   			=> 'normal',
			'content_color'   		=> '',
			'animate_block'			=> 'false',
			'animation_type'		=> 'fadeIn',
			'animation_delay'		=> '',
		), $atts ) );

		ob_start();

		$wrapper_class = array();

		if( $animate_block == 'yes' ) {
			$wrapper_class[] = 'wow';
			$wrapper_class[] = $animation_type;
		}

		$wrapper_class = implode( ' ', $wrapper_class );
		
		
		$color_class = array();

    if ( $content_color == 'yes' ) {
      $color_class[] = 'light';
    }

    $color_class = implode( ' ', $color_class );
		
		
		?>
		<div  class="text-content-block wow 
					<?php echo esc_attr( $color_class ); ?> <?php if( $content_color == 'yes') ?>
					<?php echo esc_attr( $wrapper_class ); ?> " data-splitting>
			<?php echo wpb_js_remove_wpautop( $content, true ); ?>

            
		</div>
		<?php

		return ob_get_clean();
	}
}


vc_map( array(
	"base" 			    => "ts_text_content_block",
	"name" 			    => __( 'Text Content Block', 'themezinho' ),
	"icon"              => THEMEZINHO_CORE_URI . "assets/img/custom.png",
	"content_element"   => true,
	"category" 		    => PAGE_BUILDER_GROUP,
	'params' => array(
		 array(
      "type" => "dropdown",
      "heading" => __( 'Content Light Color ?', 'themezinho' ),
      "param_name" => "content_color",
      "group" => 'General',
      "value" => array(
        "No" => 'no',
        "Yes" => 'yes',
      )
    ),
		array(
			"type" 			=> 	"textarea_html",
			"heading" 		=> 	__( 'Text', 'themezinho' ),
			"param_name" 	=> 	"content",
			"group" 		=> 'General',
		),
	),
) );
