<?php
/*
Plugin Name: Themezinho Core
Plugin URI: https://themeforest.net/user/themezinho/portfolio
Description: Tourog Theme
Author: Themezinho
Version: 1.1.0
Author URI: http://themeforest.net/user/themezinho/portfolio
*/

define( "THEMEZINHO_CORE_PATH", plugin_dir_path( __FILE__ ) );
define( "THEMEZINHO_CORE_URI", plugins_url( 'themezinho_core/' ) );
define( "PAGE_BUILDER_GROUP", __( 'tourog', 'themezinho' ) );


add_action( 'vc_before_init', 'themezinho_vc_addons' );
/**
 * JS Composer Elements
 */

function themezinho_vc_addons() {
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/milestones.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/header-carousel.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/header-video-bg.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/header-slider.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/header-kinetic.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/header-text-interactive.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/testimonials.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/content-slider.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/process-content.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/contact-block.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/client.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/google-map.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/header.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/image.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/portfolio.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/section-title.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/team-member.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/text-content-block.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/icon-content-block.php';
  require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/elements/portfolio-text-content.php';
}

require_once THEMEZINHO_CORE_PATH . '/inc/js_composer/vc_extra_params.php';

/**
 * Include advanced custom field
 */
// 1. customize ACF path
add_filter( 'acf/settings/path', 'themezinho_acf_settings_path' );

function themezinho_acf_settings_path( $path ) {
  $path = THEMEZINHO_CORE_PATH . '/inc/acf/';

  return $path;
}


// 2. customize ACF dir
add_filter( 'acf/settings/dir', 'themezinho_acf_settings_dir' );

function themezinho_acf_settings_dir( $dir ) {
  $dir = THEMEZINHO_CORE_URI . '/inc/acf/';

  return $dir;
}

//Hide ACF field group menu item
add_filter( 'acf/settings/show_admin', '__return_false' );
require THEMEZINHO_CORE_PATH . '/inc/acf/acf.php';

require_once THEMEZINHO_CORE_PATH . '/inc/theme-options.php';

require_once THEMEZINHO_CORE_PATH . '/inc/cpt-taxonomy.php';


function motts_animations() {

  return array(
    'Split' => 'split',
    'Reveal' => 'reveal-effect'
  );
}


function ts_get_hero_slider() {
  $args = array(
    'post_type' => 'hero',
    'posts_per_page' => -1,
  );
  $sliders = get_posts( $args );

  $_slider = array();

  if ( count( $sliders ) ) {
    foreach ( $sliders as $slider ) {
      $_slider[ $slider->ID . ' ' . $slider->post_title ] = $slider->ID;
    }
  }

  return $_slider;
}


// default options
function tourog_after_import() {

  update_field( 'enable_preloader', 1, 'option' );
  update_field( 'pre-loader_text', esc_html__( 'SITE LOADING', 'tourog' ), 'option' );


  $social_media = array(
    array(
      'title' => esc_attr__( 'fab fa-facebook-f', 'tourog' ),
      'url' => '#',
    ),
    array(
      'title' => esc_attr__( 'fab fa-behance', 'tourog' ),
      'url' => '#',
    ),
    array(
      'title' => esc_attr__( 'fab fa-github', 'tourog' ),
      'url' => '#',
    ),
    array(
      'title' => esc_attr__( 'fab fa-youtube', 'tourog' ),
      'url' => '#',
    ),
  );
  $side_contact = array(
    array(
      'title' => esc_html__( 'hello @ tourog.net ', 'tourog' ),
      'url' => '#',
    ),
  );
  update_field( 'social_media', $social_media, 'option' );
  update_field( 'enable_soundbar', 1, 'option' );
	
  update_field( 'allcases_label', wp_kses_post( "ALL CASES" ), 'option' );
  update_field( 'scrolldown', wp_kses_post( "SCROLL DOWN" ), 'option' );

  update_field( 'nav_menu_type', 'hamburger', 'option' );

  update_field( 'archive_show_sidebar', 'no', 'option' );
  update_field( 'archive_strip_content', 'yes', 'option' );

  update_field( 'footer_show_call_to_action', 1, 'option' );
  update_field( 'footer_cta_content', wp_kses_post( "<h6>LET’S HAVE A TALK ABOUT YOUR PROJECT.</h6><h2>Need more information or want<br>to get in touch?</h2>" ), 'option' );
  update_field( 'footer_cta_button_label', esc_html__( "Get in touch" ), 'option' );
  update_field( 'footer_cta_button_link', esc_attr__( "#" ), 'option' );
}