<?php


function tourog_add_google_fonts() {

  wp_enqueue_style( 'poppins-google-fonts', 'https://fonts.googleapis.com/css?family=Poppins:400,600,800', false );
  wp_enqueue_style( 'fjalla-google-fonts', 'https://fonts.googleapis.com/css?family=Fjalla+One', false );

}

add_action( 'wp_enqueue_scripts', 'tourog_add_google_fonts' );

if ( !function_exists( 'tourog_enqueue_styles_and_scripts' ) ) {
  /**
   * This function enqueues the required css and js files.
   *
   * @return void
   */
  function tourog_enqueue_styles_and_scripts() {
    /**
     * Enqueue css files.
     */
    wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/css/fontawesome.min.css' );
    wp_enqueue_style( 'bundle', get_template_directory_uri() . '/css/bundle.min.css' );
    wp_enqueue_style( 'bootsrap', get_template_directory_uri() . '/css/bootstrap.min.css' );
    wp_enqueue_style( 'tourog-main-style', get_template_directory_uri() . '/css/style.css' );
    wp_enqueue_style( 'tourog-stylesheet', get_stylesheet_uri() );
    wp_add_inline_style( 'tourog-stylesheet', tourog_dynamic_css() );

    /**
     * Enqueue javascript files.
     */

    wp_enqueue_script( 'comments', get_template_directory_uri() . '/js/comments.js', array(), false, false );
    wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array( 'jquery' ), false, true );
    wp_enqueue_script( 'bundle', get_template_directory_uri() . '/js/bundle.js', array( 'jquery' ), false, true );
    wp_enqueue_script( 'tourog-scripts', get_template_directory_uri() . '/js/scripts.js', array( 'jquery' ), false, true );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
    }

    $data = array(
      'pre_loader_typewriter' => [],
      'audio_source' => '',
      'enable_sound_bar' => false
    );

    if ( tourog_get_option( 'enable_preloader' ) ) {
      $typewriter_text = [];
      $text_rotater = tourog_get_option( 'pre_loader_text_rotater' );
      if ( $text_rotater ) {
        foreach ( $text_rotater as $rotater ) {
          $typewriter_text[] = esc_html( $rotater[ 'title' ] );
        }
      }
      $data[ 'pre_loader_typewriter' ] = $typewriter_text;
    }
    if ( tourog_get_option( 'enable_soundbar' ) ) {
      $data[ 'audio_source' ] = tourog_get_option( 'sound_bar_audio' ) ? esc_url( tourog_get_option( 'sound_bar_audio' ) ) : get_template_directory_uri() . '/audio/audio.mp3';
      $data[ 'enable_sound_bar' ] = true;
    }

    if ( tourog_get_option( 'enable_text_split_effect' ) ) {
      $data[ 'enable_text_split_effect' ] = true;
    }

    $comment_data = array(
      'name' => esc_html__( 'Name is required', 'tourog' ),
      'email' => esc_html__( 'Email is required', 'tourog' ),
      'comment' => esc_html__( 'Comment is required', 'tourog' ),

    );

    wp_localize_script( 'tourog-scripts', 'data', $data );
    wp_localize_script( 'comments', 'comment_data', $comment_data );
  }

  add_action( 'wp_enqueue_scripts', 'tourog_enqueue_styles_and_scripts', 10 );
}

if ( !function_exists( 'tourog_dynamic_css' ) ) {
  function tourog_dynamic_css() {

    $styles = '';
    if ( tourog_get_option( 'logo_height' ) ) {
      $logo_height = str_replace( ' ', '', tourog_get_option( 'logo_height' ) );
      $logo_height = str_replace( 'px', '', $logo_height );
      $styles .= "
				.left-side .logo img{
					height: {$logo_height}px;
				}
			";
    }
    if ( tourog_get_option( 'enable_dynamic_color' ) ) {

      $site_color = ( tourog_get_option( 'theme_color' ) ) ? tourog_get_option( 'theme_color' ) : '#75dab4';
      $site_color2 = ( tourog_get_option( 'theme_color2' ) ) ? tourog_get_option( 'theme_color2' ) : '#222327';
      $site_color3 = ( tourog_get_option( 'theme_color3' ) ) ? tourog_get_option( 'theme_color3' ) : '#161619';

      $styles .= "
	  
	  
	  :root {
  --color-main: {$site_color}; 
  --color-dark: {$site_color2}; 
  --color-darker: {$site_color3}; 
}

				
			";
    }

    return $styles;
  }
}

add_action( 'init', 'tourog_dynamic_css' );
add_action(
  'after_setup_theme',
  function () {
    add_theme_support( 'html5', [ 'script', 'style' ] );
  }
);