<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package tourog
 */

?>
<div class="post-content">
    <div class="post-inner">
        <?php
        if ( 'post' === get_post_type() ) :
            ?>
            <small class="post-date wow" data-splitting><?php the_time('F d, Y'); ?></small>
            <?php tourog_posted_by(); ?>
		<?php the_tags( '<ul class="post-tags wow" data-splitting><li>', '</li><li>', '</li></ul>' ); ?>
        <?php endif;
        ?>
		
		<h3 class="post-title wow" data-splitting><?php the_title(); ?></h3>
		
		
    </div>

    

    <?php
    the_content( sprintf(
'%s %s',
        esc_html__('Continue reading', 'tourog'),
        '<span class="screen-reader-text"> ' . get_the_title() . '</span>'
    ) );

    wp_link_pages( array(
        'before'      => '<div class="page-links"><h6>' . esc_html__( 'Pages:',  'tourog' ) . '</h6>',
        'after'       => '</div>',
        'link_before' => '<span>',
        'link_after'  => '</span>',
    ) );
    ?>
    <div class="post-entry-footer">
        <?php tourog_entry_footer(); ?>
    </div>

</div>